function inv = geometric_inv (x, p)
  
  # usage:   geometric_inv (x, p)
  #
  # For each element of x, compute the quantile at x of the geometric
  # distribution with parameter p. 

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 2)
    error ("usage:  geometric_inv (x, p)");
  endif

  [retval, x, p] = common_size (x, p);
  if (retval > 0)
    error (["geometric_inv:  ", ...
	"x and p must be of common size or scalar"]);
  endif
  
  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, 1, s);
  p   = reshape (p, 1, s);
  inv = zeros (1, s);

  k = find (!(x >= 0) | !(x <= 1) | !(p >= 0) | !(p <= 1));
  if any (k)
    inv(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x == 1) & (p >= 0) & (p <= 1));
  if any (k)
    inv(k) = Inf * ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < 1) & (p > 0) & (p <= 1));
  if any (k)
    inv(k) = max (ceil (log (1 - x(k)) ./ log (1 - p(k))) - 1, ...
	zeros (1, length (k)));
  endif
 
  inv = reshape (inv, r, c);
  
endfunction
