function pdf = geometric_pdf (x, p)
  
  # usage:   geometric_pdf (x, p)
  #
  # For each element of x, compute the probability density function
  # (PDF) at x of the geometric distribution with parameter p.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 2)
    error ("usage:  geometric_pdf (x, p)");
  endif

  [retval, x, p] = common_size (x, p);
  if (retval > 0)
    error (["geometric_pdf:  ", ...
	"x and p must be of common size or scalar"]);
  endif
  
  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, 1, s);
  p   = reshape (p, 1, s);
  cdf = zeros (1, s);

  k = find (isnan (x) | !(p >= 0) | !(p <= 1));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif
  
  # Just for the fun of it ...
  k = find ((x == Inf) & (p == 0));
  if any (k)
    pdf(k) = ones (1, length (k));
  endif
  
  k = find ((x >= 0) & (x < Inf) & (x == round (x)) ...
      & (p > 0) & (p <= 1));
  if any (k)
    pdf(k) = p(k) .* ((1 - p(k)) .^ x(k));
  endif
 
  pdf = reshape (pdf, r, c);
  
endfunction
