function y = iqr (x)
  
  # usage:  iqr (x)
  #
  # If x is a vector, return the interquartile range, i.e., the
  # difference between the upper and lower quartile, of the input
  # data. 
  # If x is a matrix, do the above for each column of x.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/10/15
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 1)
    error ("usage:  iqr (x)");
  endif

  y = emp_inv (x, 3/4) - emp_inv (1/4);
  
endfunction

  