function cdf = laplace_cdf (x)
  #
  # usage:   laplace_cdf (x)
  #
  # For each element of x, compute the cumulative distribution
  # function (CDF) at x of the Laplace distribution.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  laplace_cdf (x)");
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  cdf = zeros (1, s);

  k = find (isnan (x));
  if any (k)
    cdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find (x == Inf);
  if any (k)
    cdf(k) = ones (1, length (k));
  endif
  
  k = find ((x > -Inf) & (x < Inf));
  if any (k)
    cdf(k) = (1 + sign (x(k)) .* (1 - exp (- abs (x(k))))) / 2;
  endif

  cdf = reshape (cdf, r, c);
  
endfunction