function inv = laplace_inv (x)
  #
  # usage:   laplace_inv (x)
  #
  # For each element of x, compute the quantile (the inverse of the
  # CDF) at x of the Laplace distribution.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  laplace_inv (x)");
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  inv = (-Inf) * ones (1, s);

  k = find (isnan (x) | (x < 0) | (x > 1));
  if any (k)
    inv(k) = NaN * ones (1, length (k));
  endif
  
  k = find (x == 1);
  if any (k)
    inv(k) = Inf * ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < 1));
  if any (k)
    inv(k) = (x(k) < 1/2) .* log (2 * x(k)) ...
	- (x(k) > 1/2) .* log (2 * (1 - x(k)));
  endif

  inv = reshape (inv, r, c);
  
endfunction