function pdf = laplace_pdf (x)
  #
  # usage:   laplace_pdf (x)
  #
  # For each element of x, compute the probability density function
  # (PDF) at x of the Laplace distribution.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  laplace_pdf (x)");
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  pdf = zeros (1, s);

  k = find (isnan (x));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x > -Inf) & (x < Inf));
  if any (k)
    pdf(k) = exp (- abs (x(k))) / 2;
  endif

  pdf = reshape (pdf, r, c);
  
endfunction