function rnd = laplace_rnd (r, c)
  
  # usage:  laplace_rnd (r, c)
  #
  # Return an r by c matrix of random numbers from the Laplace
  # distribution.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/11/01
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  laplace_rnd (r, c)");
  endif

  if !(is_scalar (r) && (r > 0) && (r == round (r)))
    error ("laplace_rnd:  r must be a positive integer");
  endif
  if !(is_scalar (c) && (c > 0) && (c == round (c)))
    error ("laplace_rnd:  c must be a positive integer");
  endif

  current_distribution = rand ("dist");
  rand ("uniform");
  tmp = rand (r, c);
  rnd = (tmp < 1/2) .* log (2 * tmp) ...
      - (tmp > 1/2) .* log (2 * (1 - tmp));
  rand (current_distribution);
  
endfunction
