function cdf = logistic_cdf (x)
  
# usage:  logistic_cdf (x)
#
# For each component of x, compute the CDF at x of the logistic 
# distribution.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/27
# Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    usage ("logistic_cdf (x)");
  endif

  cdf = 1 ./ (1 + exp (- x));
  
endfunction
