function inv = logistic_inv (x)

# usage:  logistic_inv (x)
#
# For each component of x, compute the quantile (the inverse of the
# CDF) at x of the logistic distribution.

# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/28
# Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 1)
    usage ("logistic_inv (x)");
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  inv = zeros (1, s);

  k = find ((x < 0) | (x > 1) | isnan (x));
  if any (k)
    inv(k) = NaN * ones (1, length (k));
  endif

  k = find (x == 0);
  if any (k)
    inv(k) = (-Inf) * ones (1, length (k));
  endif

  k = find (x == 1);
  if any (k)
    inv(k) = Inf * ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < 1));
  if any (k)
    inv (k) = - log (1 ./ x(k) - 1);
  endif
  
  inv = reshape (inv, r, c);
  
endfunction
