function pdf = logistic_pdf (x)
  
# usage:  logistic_pdf (x)
#
# For each component of x, compute the PDF at x of the logistic 
# distribution.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/27
# Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    usage ("logistic_pdf (x)");
  endif

  cdf = logistic_cdf (x);
  pdf = cdf .* (1 - cdf);
  
endfunction
