function [dl, d2l] ...
      = logistic_regression_derivatives (x, z, z1, g, g1, p)
  
  # Called by logistic_regression.  Calculates derivates of the 
  # log-likelihood for ordinal logistic regression model.
  
  # Original by Gordon K. Smyth <gks@maths.uq.oz.au>
  # Adapted for Octave by KH <Kurt.Hornik@tuwien.ac.at>

  # first derivative
  v = g .* (1 - g) ./ p; v1 = g1 .* (1 - g1) ./ p;
  dlogp = [dmult (v, z) - dmult (v1, z1) dmult (v - v1, x)];
  dl = sum (dlogp)';

  # second derivative
  w = v .* (1 - 2 * g); w1 = v1 .* (1 - 2 * g1);
  d2l = [z x]' * dmult (w, [z x]) - [z1 x]' * dmult (w1, [z1 x]) ...
      - dlogp' * dlogp;
  
endfunction