function [g, g1, p, dev] ...
      = logistic_regression_likelihood (y, x, beta, z, z1)
  
  # Calculates likelihood for the ordinal logistic regression model.
  # Called by logistic_regression.
  
  # Original by Gordon K. Smyth <gks@maths.uq.oz.au>
  # Adapted for Octave by KH <Kurt.Hornik@tuwien.ac.at>
  
  e = exp ([z x] * beta); e1 = exp ([z1 x] * beta);
  g = e ./ (1 + e); g1 = e1 ./ (1 + e1);
  g = max (y == max (y), g); g1 = min (y > min(y), g1);
  
  p = g - g1;
  dev = -2 * sum (log (p));  

endfunction
