function rnd = logistic_rnd (r, c)
  
# usage:  logistic_rnd (r, c)
#
# Return an r by c matrix of random numbers from the logistic
# distribution. 
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/28
# Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    usage ("logistic_rnd (r, c)");
  endif

  if !(is_scalar (r) && (r > 0) && (r == round (r)))
    error ("logistic_rnd:  r must be a positive integer");
  endif
  if !(is_scalar (c) && (c > 0) && (c == round (c)))
    error ("logistic_rnd:  c must be a positive integer");
  endif

  current_distribution = rand ("dist");
  rand ("uniform");
  rnd = - log (1 ./ rand (r, c) - 1);
  rand (current_distribution);
  
endfunction
