function y = mean (x, opt)

# usage:  mean (x [, opt])
#
# For vector arguments, return the mean the values.
# For matrix arguments, return a row vector containing the mean for
# each column.
#
# With the optional argument opt, the kind of mean computed can be
# selected.
# If opt is "a", the (ordinary) arithmetic mean is computed.  This
# is the default.
# If opt is "g", the geometric mean is computed.
# If opt is "h", the harmonic mean is computed.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/10/22
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/02/06
# Copyright Dept of Probability Theory and Statistics TU Wien.

  if ((nargin < 1) || (nargin > 2))
    usage ("mean (x [, opt])");
  endif

  if isempty (x)
    error ("mean:  x must not be empty");
  endif
  
  if (rows (x) == 1)
    x = x';
  endif
  
  if (nargin == 1)
    opt = "a";
  endif

  [r, c] = size (x);
  
  if (strcmp (opt, "a"))
    y = sum (x) / r;
  elseif (strcmp (opt, "g"))
    y = NaN * ones (1, c);
    i = find (all (x > 0));
    if any (i)
      y(i) = exp (sum (log (x(:, i))) / r);
    endif
  elseif (strcmp (opt, "h"))
    y = NaN * ones (1, c);
    i = find (all (x <> 0));
    if any (i)
      y(i) = r ./ sum (1 ./ x(:, i));
    endif
  else
    error (sprintf ("mean:  option `%s' not recognized", opt));
  endif
    
endfunction
