function m = moment (x, p, opt)
  
  # usage:  moment (x, p [, opt])
  #
  # Computes the p-th moment of x if it is a vector;  if x is a
  # matrix, return the row vector of the p-th moment of each column.
  #
  # With the optional string opt, the kind of moment to be computed
  # can be specified.  If opt contains `c' or `a', central and/or
  # absolute moments are returned.  I.e., `moment(x, 3, "ac")'
  # computes the third central absolute moment of x. 

  # Can easily be made to work for continuous distributions (using
  # quad) as well, but how does the general case work?
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 9, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if ((nargin < 2) || (nargin > 3))
    error ("usage:  moment (x, p [, type]")
  endif
  
  [nr, nc] = size (x);
  if (nr == 0 || nc == 0)
    error ("moment:  x must not be empty");
  elseif (nr == 1)
    x  = reshape (x, nc, 1);
    nr = nc;
  endif
  
  if (nargin == 3)
    tmp = implicit_str_to_num_ok;
    implicit_str_to_num_ok = "true";
    if any (opt == "c")
      x = x - ones (nr, 1) * sum (x) / nr;
    endif
    if any (opt == "a")
      x = abs (x);
    endif
    implicit_str_to_num_ok = tmp;
  endif
  
  m = sum(x .^ p) / nr;
  
endfunction
