function pdf = poisson_pdf (x, l)
  
  # usage:   poisson_pdf (x, lambda)
  #
  # For each element of x, compute the probability density function
  # (PDF) at x of the poisson distribution with parameter lambda.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 2)
    error ("usage:  poisson_pdf (x, lambda)");
  endif
  
  [retval, x, l] = common_size (x, l);
  if (retval > 0)
    error (["poisson_pdf:  ", ...
	"x and lambda must be of common size or scalar"]);
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  l = reshape (l, 1, s);
  pdf = zeros (1, s);

  k = find (!(l > 0) | isnan (x));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif

  k = find ((x >= 0) & (x < Inf) & (x == round (x)) & (l > 0));
  if any (k)
    pdf(k) = exp (x(k) .* log (l(k)) - l(k) - lgamma (x(k) + 1));
  endif
  
  pdf = reshape (pdf, r, c);
  
endfunction

