function [Nout,Xout]=prob(Y,n,mode);
% function [N,X]=prob(Y,n,mode) plots a probability density.
%
% Y    - data vector.
% n    - number of bins, default 10.
% mode - "lin" (default) or "log" (semi-logarithmic) plot.
% N,X  - Height and position of the bars. If specified, result is not
%        plotted, only returned.

if nargin<1
  help prob
  return
elseif nargin<2 
  n=10; mode="lin"; 
elseif nargin<3
  mode="lin";
  if isstr(n), mode=n; n=10; end
end
                                          % Do the work
[N,X]=hist(Y,n);
N=N/(sum(N)*(X(2)-X(1)));

if nargout==0                             % Plot
  if mode=="lin"
    bar(X,N); 
  else
    [xb,yb]=bar(X,N);
    yzero=find(yb==0);
    ymin=min(yb(find(yb~=0)));
    yb(yzero)=ymin/2*ones(size(yzero));
    semilogy(xb,yb);
  end
end

if nargout>0, Nout=N; Xout=X; end         % Output

