function y = ranks (x)

# usage:  ranks (x)
#
# If x is a vector, return the (column) vector of ranks of x adjusted
# for ties.  
# If x is a matrix, do the above for each column of x.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jan 21, 1995.
# Copyright Dept of Probability Theory and Statistics TU Wien
#
# This code is rather ugly, but is there an easy way to get the ranks
# adjusted for ties from sort? 
  
  if (nargin <> 1)
    usage ("ranks (x)");
  endif
  
  y = [];

  [r, c] = size (x);
  if ((r == 1) && (c > 0))
    p = x' * ones (1, c);
    y = sum (p < p') + (sum (p == p') + 1) / 2;
  elseif (r > 1)
    o = ones (1, r);
    for i = 1 : c;
      p = x (:, i) * o;
      y = [y, ( sum (p < p') + (sum (p == p') + 1) / 2 )'];
    endfor
  endif
  
endfunction

  
