function retval = run_count (x, n)
  
  # usage: run_count (x, n)
  #
  # Counts the upward runs in the columns of x of length 1, 2, ... n-1
  # and >= n. 

  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Jul 18, 1994 
  # Copyright Department of Probability Theory and Statistics, TU Wien

  [xr, xc] = size(x);
  
  tmp = zeros (xr,xc);
  retval = zeros (n, xc);
  
  for j = 1 : xc
    run = 1;
    count = 1;

    for k = 2 : xr

      if x(k, j) < x(k-1, j)
	tmp(run, j) = count;
	run = run + 1;
	count = 0;
      endif
    
      count = count + 1;

    endfor

    tmp(run, j) = count;
  
  endfor
  
  for k=1 : (n-1)
    retval(k, :) = sum (tmp == k);
  endfor
  retval(n, :) = sum (tmp >= n);
  
endfunction
