function S = statistics (X)
  
  # usage:  S = statistics (X)
  #
  # If X is a matrix, return a matrix S with the min, first quartile, 
  # median, third quartile, max, mean, std, skewness and kurtosis of
  # the columns of X as its rows. 
  # If X is a vector, treat it as a column vector.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 94/07/29
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 94/10/08
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 1)
    error ("usage:  S = statistics (X)");
  endif

  if (prod (size (X)) > 1)
    if (is_vector (X))
      X = reshape (X, length (X), 1);
    endif
    S = [ min (X); emp_inv (X, 1/4); median (X); emp_inv (X, 3/4);
	max (X); mean (X); std (X); skewness (X); kurtosis (X) ];
  else
    error ("statistics:  invalid argument");
  endif
  
endfunction
  