function cdf = stdnormal_cdf (x)
  
  # usage:  stdnormal_cdf (x)
  #
  # For each component of x, compute the CDF of the standard normal
  # distribution at x.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 12, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  stdnormal_cdf (x)");
  endif

  [r_x, c_x] = size (x);
  if (r_x * c_x == 0)
    error ("stdnormal_cdf:  x must not be empty.");
  endif

  cdf = ( ones (r_x, c_x) + erf (x / sqrt(2)) ) / 2; 
  
endfunction
  



