function inv = stdnormal_inv (x)
  
  # usage:  stdnormal_inv (x)
  #
  # For each component of x, compute compute the quantile (the inverse
  # of the CDF) at x of the standard normal distribution.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 27, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    error ("usage:  stdnormal_inv (x)");
  endif
  
  inv = sqrt (2) * erfinv (2 * x - 1);
  
endfunction
