function pdf = stdnormal_pdf (x)

  # usage:   stdnormal_pdf (x)
  #
  # For each element of x, compute the probability density function
  # (PDF) of the standard normal distribution at x. 
  
  # Written by TT (Teresa.Twaroch@ci.tuwien.ac.at) on Jun 3, 1993
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  stdnormal_pdf (x)");
  endif
  
  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  pdf = zeros (1, s);
  
  k = find (isnan (x));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find (!isinf (x));
  if any (k)
    pdf (k) = (2 * pi)^(- 1/2) * exp( - x(k) .^ 2 / 2);
  endif
  
  pdf = reshape (pdf, r, c);
  
endfunction