function rnd = stdnormal_rnd (r, c)
  
  # usage:  stdnormal_rnd (r, c)
  #
  # Return an r by c matrix of random numbers from the standard normal
  # distribution.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 9, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 31, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  stdnormal_rnd (r, c)");
  endif

  if !(is_scalar (r) && (r > 0) && (r == round (r)))
    error ("stdnormal_rnd:  r must be a positive integer");
  endif
  if !(is_scalar (c) && (c > 0) && (c == round (c)))
    error ("stdnormal_rnd:  c must be a positive integer");
  endif

  current_distribution = rand ("dist");
  rand ("normal");
  rnd = rand (r, c);
  rand (current_distribution);
  
endfunction
