function t = studentize (x)
  
# usage:  studentize (x)
#
# If x is a vector, subtract its mean and divide by its standard
# deviation. 
# If x is a matrix, do the above for each column.

# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/07/31. 
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/01/21. 
# Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    usage ("studentize (x)");
  endif

  if is_vector (x)
    if (std (x) == 0)
      t = zeros (size (x));
    else
      t = (x - mean (x)) / std (x);
    endif
  elseif is_matrix (x)
    l = ones (rows (x), 1);
    t = x - l * mean (x);
    t = t ./ (l * max ([std (t); !any (t)]));
  else
    error ("studentize:  x must be a vector or a matrix.");
  endif

endfunction