function rnd = t_rnd (n, r, c)
  #
  # usage:  t_rnd (n [, r, c])
  #
  # t_rnd (n) returns a matrix of random samples from the t (Student)
  # distribution with n degrees of freedom.  The size of the matrix is
  # the size of n. 
  #
  # t_rnd (n, r, c) returns an r by c matrix of random samples from
  # the t distribution with n degrees of freedom.  n must be a scalar
  # or of size r by c.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/11/01
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin == 3)
    if !(is_scalar (r) && (r > 0) && (r == round (r)))
      error ("t_rnd:  r must be a positive integer");
    endif
    if !(is_scalar (c) && (c > 0) && (c == round (c)))
      error ("t_rnd:  c must be a positive integer");
    endif
    [retval, n] = common_size (n, zeros (r, c));
    if (retval > 0)
      error (["t_rnd:  ", ...
	  "n must be scalar or of size ", ... 
	  sprintf ("%d by %d", r, c)]);
    endif
  else
    if !(nargin == 1)
      error ("usage:  t_rnd (n [, r, c])");
    endif
  endif
  
  [r, c] = size (n);
  s = r * c;
  n = reshape (n, 1, s);
  rnd = zeros (1, s);
  
  k = find (!(n > 0) | !(n < Inf) | !(n == round (n)));
  if any (k)
    rnd(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((n > 0) & (n < Inf) & (n == round (n)));
  if any (k)
    current_distribution = rand ("dist");
    rand ("uniform");
    rnd(k) = t_inv (rand (1, length (k)), n(k));
    rand (current_distribution);
  endif
  
  rnd = reshape (rnd, r, c);
  
endfunction
