function inv = uniform_inv (x, a, b)
  
  # usage:  uniform_inv (x [, a, b])
  #
  # For each element of x, compute the quantile (the inverse of the
  # CDF) at x of the uniform distribution on [a, b].
  # Default values are a = 0, b = 1.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 31, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994 
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if !(nargin == 1 || nargin == 3)
    error ("usage:  uniform_inv (x [, a, b])");
  endif

  if (nargin == 1)
    a = 0;
    b = 1;
  endif
  
  [retval, x, a, b] = common_size (x, a, b);
  if (retval > 0)
    error ("uniform_inv:  x, a and b must be of common size or scalars");
  endif

  [r, c] = size (x);
  s   = r * c;
  x   = reshape (x, 1, s);
  a   = reshape (a, 1, s);
  b   = reshape (b, 1, s);
  inv = zeros (1, s);
  
  k = find ((x < 0) | (x > 1) | isnan (x) | !(a < b));
  if any (k)
    inv(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x >= 0) & (x <= 1) & (a < b));
  if any (k)
    inv(k) = a(k) + x(k) .* (b(k) - a(k));
  endif

  inv = reshape (inv, r, c);
  
endfunction
