function pdf = uniform_pdf (x, a, b)
  
  # usage:  uniform_pdf (x [, a, b])
  #
  # For each element of x, compute the PDF at x of the uniform
  # distribution on [a, b]. 
  # Default values are a = 0, b = 1.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jul 31, 1994. 
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994. 
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if !(nargin == 1 || nargin == 3)
    error ("usage:  uniform_pdf (x [, a, b])");
  endif

  if (nargin == 1)
    a = 0;
    b = 1;
  endif

  [retval, x, a, b] = common_size (x, a, b);
  if (retval > 0)
    error (["uniform_pdf:  ", ...
	"x, a and b must be of common size or scalars"]);
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  a = reshape (a, 1, s);
  b = reshape (b, 1, s);
  pdf = zeros (1, s);
  
  k = find (isnan (x) | !(a < b));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x > a) & (x < b));
  if any (k)
    pdf(k) = 1 ./ (b(k) - a(k));
  endif
  
  pdf = reshape (pdf, r, c);
  
endfunction
