function y = var(x)
  
  # usage:   var (x)
  #
  # For vector arguments, return the (real) variance of the values.
  # For matrix arguments, return a row vector contaning the variance
  # for each column. 
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 9, 1994.
  # Copyright Dept of Probability Theory and Statistics TU Wien.

  if (nargin <> 1)
    error ("usage:  var (x)");
  endif
  
  [nr, nc] = size (x);
  if (nr == 0 || nc == 0)
    error ("var:  x must not be empty");
  elseif ((nr == 1) && (nc == 1))
    y = 0;
  elseif ((nr == 1) || (nc == 1))
    n = length (x);
    y = (sumsq (x) - sum(x)^2 / n) / (n - 1);
  else
    y = (sumsq (x) - sum(x).^2 / nr) / (nr - 1);
  endif
  
endfunction
    
