function inv = weibull_inv (x, l, a)
  
  # usage:  weibull_inv (x, lambda, alpha)
  #
  # For each component of x, compute the quantile (the inverse of the
  # CDF) at x of the Weibull distribution with parameters lambda and
  # alpha.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/10/26
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 3)
    error ("usage:  weibull_inv (x, lambda, alpha)");
  endif

  [retval, x, l, a] = common_size (x, l, a);
  if (retval > 0)
    error (["weibull_inv:  ", ...
	"x, lambda and alpha must be of common size or scalar"]);
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  l = reshape (l, 1, s);
  a = reshape (a, 1, s);
  inv = zeros (1, s);
  
  k = find (!(a > 0) | !(l > 0) | (x < 0) | (x > 1) | isnan (x));
  if any (k)
    inv(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x == 1) & (a > 0) & (l > 0));
  if any (k)
    inv(k) = Inf * ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < 1) & (a > 0) & (l > 0));
  if any (k)
    inv(k) = (- log (1 - x(k)) ./ l(k)) .^ (1 ./ a(k));
  endif

  inv = reshape (inv, r, c);
  
endfunction
