function retval = wiener_rnd (t, d, n)

  # usage:  wiener_rnd (t [, d [,n]])
  #  
  # Returns a simulated realization of the d-dimensional Wiener
  # Process on the interval [0,t].  If d is omitted, d=1 is used.
  # The first column of the return matrix contains time, the
  # remaining columns contain the Wiener process.
  # The optional parameter n gives the number of summands used for
  # simulating the process over an interval of length 1.  If n is
  # omitted, n=1000 is used. 

  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Jun 10, 1994
  # Updated by FL on Sep 7, 1994
  # Copyright Department of Probability Theory and Statistics TU Wien

  if (nargin == 1)
    d = 1;
    n = 1000;
  elseif (nargin == 2)
    n = 1000;
  elseif (nargin > 3)
    error ("usage:  wiener_rnd (t [, d [,n]])");
  endif

  oldist = rand ("dist");
  rand("normal");

  retval = rand (n * t, d);
  retval = cumsum (retval) / sqrt (n);

  retval = [(1: n*t)' / n retval];

  rand (oldist);

endfunction



