function y=dct(x,n)
#
# usage: y = dct(x)
#
#  Returns the discrete cosine transform of x. If x is 
#  a matrix, the operation is applied to each column.
#
# usage: y = dct(x,n)
#
#  Returns the discrete cosine transform of x padded or
#  truncated to n before transforming.
#
#  Note: The function executes faster for real valued vectors
#        of even length.
# 
#       See also idct, fft, ifft.

#   Copyright by LA de Waal (ladewaal@umberto.csir.co.za) 28 October 1995.

#  error(nargchk(1,2,nargin));

  save_do_fortran_indexing = do_fortran_indexing;
  do_fortran_indexing = "true";

  if (is_vector(x)) 
    isrowvec = (size(x,2) > 1);
    x = x(:); 
  else  
    isrowvec = 0; 
  endif

  # Pad or truncate x if necessary
  if (nargin == 2)
    [mx,nx] = size(x);
    if (mx < n)
      x = [ x; zeros(n - mx, nx) ];
    else
      x = x(1:n,:);
    endif
  endif

  [m,n] = size(x);

  if (isreal(x) && (rem(m,2) == 0))
    xp = 2 * fft([ x(1:2:m,:); x(m:-2:2,:) ]);
  else
    xp = fft([ x; flipud(x) ]);
    xp = xp(1:m,:);
  endif

  w = exp(-sqrt(-1) * (0:m-1) * pi/(2*m)).';
  y = w(:,ones(1,n)) .* xp;

  if (isrowvec) 
    y = y.'; 
  endif

  if (isreal(x))
    y = real(y);
  endif

  do_fortran_indexing = save_do_fortran_indexing;
    
endfunction










