function y=dct2(x, mp, np)
#
# usage: y = dct2(x)
#
#  Returns the two-dimensional discrete cosine transform of x. 
#
# usage: y = dct2(x, [m, n])
#    or  y = dct2(x, m, n)
#
#  Returns the 2-D discrete cosine transform of x padded or
#  truncated to size m-by-n before transforming.
#
# usage: y = dct2(x, m)
#
#  Returns the 2-D discrete cosine transform of x padded or
#  truncated to size m-by-m before transforming.
#
#  Note: The function executes faster for real valued square matrices
#  of even dimensions.
# 
#       See also idct2, fft2, ifft2.

#   Copyright by LA de Waal (ladewaal@umberto.csir.co.za) 28 October 1995.

  [m, n] = size(x);

  if (nargin == 1) 
    y = dct(dct(x).').';
    return
  endif

  save_do_fortran_indexing = do_fortran_indexing;
  do_fortran_indexing = "true";
  
  if (nargin == 2)
    np = mp(1 + (length(mp) > 1)) ; 
    mp = mp(1); 
  endif

  if (m == 1 && mp > m)
    x(++m, 1) = 0; 
  endif
  if (n == 1 && np > n)
    x(1, ++n) = 0; 
  endif
  if (m == 1) 
    mp = np;
    np = 1;
  endif

  do_fortran_indexing = save_do_fortran_indexing;

  y = dct(dct(x, mp).', np).'; 

endfunction













