function y = filter2(b,x,area)
#
# usage: y = filter(f,x)
# 
# Filters the data x with the two-dimensional FIR filter in f  
# using 2-D convolution. The result y is the same size as image x.
#
# usage: y = filter(f,x,area)
#
# Returns a subsection of the result specified by 'area':
#    "full"  - returns the full 2-D convolution, size(y) > size(x).
#    "same"  - returns a matrix of the same size as image x
#              from the central part of the convolution.(default) 
#    "valid" - returns the part of the convolution that
#              corresponds to a 'true' convolution, i.e. the
#              part that is computed without the zero-padded
#              edges, size(y) < size(x).
#
#	See also conv2.

#   Copyright by LA de Waal (ladewaal@umberto.csir.co.za) 22 October 1995.

  error(nargchk(2,3,nargin));
  if (nargin < 3) 
    area = "same"; 
  endif

  y = conv2(x,rot90(f,2),area);

endfunction
















