function z = xcorr2(x,y)
#
# usage: z = xcorr2(x,y)
# 
#   Returns the two-dimensional crosscorrelation of matrices x and y.
# 
# usage: z = xcorr2(x)
# 
#   Returns the two-dimensional autocorrelation of matrix x.
#
#	See also conv2

#   Copyright by LA de Waal (ladewaal@umberto.csir.co.za) 22 October 1995.

  error(nargchk(1,2,nargin));

  if (nargin == 1)
    y = conj(x);
  else
    y = conj(y);
  end

  z = conj(conv2(x,rot90(y,2)));

endfunction











