function z = xcov(x,y,option)
#
# usage : z = xcov(x, y)
# 
#   Returns the cross-covariance estimate of vector x and vector y,
#   the cross-correlation of two sequences whose means are removed. 
#
# usage : z = xcov(x)
#
#   Returns the auto-covariance estimate of vector x.
#   If x is a matrix of size m-by-n the function returns a 2*m-1
#   by n^2 matrix whose rows contain the the cross-correlation 
#   sequences for all combinations of the columns of x. Added for 
#   Matlab compatibility.
#
# usage : z = xcov(x,y,option)
#    or : z = xcov(x,option) 
#
#   Returns the cross-covariance of vector x and vector y, both of 
#   length L,  using the normalisation technique specified by option:
#     "none"     - No normalisation (default).
#     "biased"   - Biased estimate: scales the estimate by 1/L.
#     "unbiased" - Scales the estimate by 1/(L-abs(idx)), where idx
#                  is the index into the result, with zero lag at 
#                  idx = 0;
#     "coeff"    - Scales the estimate to ensure that the covariance
#                  at zero lag equals 1.  For complex values the absolute
#                  value of the covariance at zero lag equals 1.

#   Copyright by LA de Waal (ladewaal@umberto.csir.co.za) 28 October 1995.

#  error(nargchk(1,3,nargin));

  [mx,nx] = size(x);
  x = x - ones(mx,1)*mean(x);
  if (nargin == 1)
    z = xcorr(x);
  elseif (nargin == 2)
    if isstr(y)
      z = xcorr(x, y);
    else
      [my,ny] = size(y);
      z = xcorr(x, y - ones(my,1)*mean(y));
    end
  else
    [my,ny] = size(y);
    z = xcorr(x, y - ones(my,1)*mean(y), option);
  endif

endfunction






