function bottom_title (text)

% usage: bottom_title (text)
%
% NOTE: this will work only with gnuplot installed with
%       multiplot patch
%
% makes a title with the given text at the bottom of the plot 
% rather than the top.
%

%
%    Autor: Vinayak Dutt, Dutt.Vinayak@mayo.EDU
%

  if (nargin != 1)
    error ("usage: bottom_title (text)");
  endif

  if (isstr (text))
    set top_title
    set title
    command = sprintf ("set bottom_title \"%s\"", text);
    eval (command);
  else
    error ("error: bottom_title: text must be a string");
  endif

endfunction
