function mplot (...)
# usage: mplot (x, y)
#        mplot (x1, y1, x2, y2, ...)
#        mplot (x, y, fmt)
#
# This is a modified version of plot() command to work with
# multiplot version of gnuplot to plot multiple plots per page.
# This plot version automatically updates the plot position to
# next plot position after making the plot in the given subplot
# position.
#
# See command plot() for the various options to this command
# as this is just mulitplot version of the same command.
#

%
%    Autor: Vinayak Dutt, Dutt.Vinayak@mayo.EDU
%

#
# global variables to keep track of multiplot options
#
  global multiplot_mode 
  global multi_xsize multi_ysize 
  global multi_xn multi_yn
  global multi_xi multi_yi
#
  set nologscale;
  set nopolar;

  plot_int ("plot", all_va_args);
#
# update the plot position
#
  if ( multiplot_mode == 1 )
  	if ( multi_xi < multi_xn )
		multi_xi = multi_xi + 1;
	else
		multi_xi = 1;
		if( multi_yi < multi_xn )
			multi_yi = multi_yi + 1;
		else
			multi_yi = 1;
		endif;
	endif;
	xo = (multi_xi - 1.0)*multi_xsize;
	yo = (multi_yn - multi_yi)*multi_ysize;
	command = sprintf ("set origin %g,%g", xo,yo);
	eval (command);
  endif;
endfunction



