function multiplot (xn,yn)
% usage: multiplot (xn,yn)
%
% NOTE: this will work only with gnuplot installed with
%       multiplot patch
%
%    Sets and resets multiplot mode
%
%    if multiplot(0,0) then it will close multiplot mode and
%    and if arguments are non-zero, then it will set up
%    multiplot mode with xn,yn subplots along x and y axes.
%
% See other plotting commands too.

%
%    Autor: Vinayak Dutt, Dutt.Vinayak@mayo.EDU  3 Jul 95 
%

%
% global variables to keep track of multiplot options
%
  global multiplot_mode 
  global multi_xsize multi_ysize 
  global multi_xn multi_yn
  global multi_xi multi_yi
%
% check calling argument count

  if (nargin != 2)
	error "usage: multiplot (xn,yn)"
  endif

% check for scalar inputs

  if (!(is_scalar(xn) && is_scalar(yn)))
	error ("multiplot: xn and yn have to be scalars");
  endif

  xn = fix(xn);
  yn = fix(yn);

  if ( xn == 0 && yn == 0 )
	set nomultiplot;
	set size 1,1
	set origin 0,0
	multiplot_mode = 0;
	multi_xsize = 1;
	multi_ysize = 1;
	multi_xn = 1;
	multi_yn = 1;
	multi_xi = 1;
	multi_yi = 1;
	return;
  else
 	if ( ( xn < 1 ) || ( yn < 1 ) )
		error ("multiplot: xn and yn have to be positive int");
	endif;

	set multiplot;
	xsize = 1.0 ./ xn;
	ysize = 1.0 ./ yn;
    	command = sprintf ("set size %g,%g", xsize,ysize);
	eval (command);
  	xo = 0.0;
	yo = (yn - 1.0)*ysize;
    	command = sprintf ("set origin %g,%g", xo,yo);
	eval (command);
	multiplot_mode = 1;
	multi_xsize = xsize;
	multi_ysize = ysize;
	multi_xn = xn;
	multi_yn = yn;
	multi_xi = 1;
	multi_yi = 1;
  endif;

endfunction
