function plot_border (side, ...)
% usage: plot_border (side, ...)
%
% NOTE: this will work only with gnuplot installed with
%       multiplot patch
%
% multiple arguments allowed to specify the sides on which
% the border is shown. allowed strings:
%
% allowed input strings:
%
%  "blank", "BLANK", "b", "B",   --->  No borders displayed
%    "all",   "ALL", "a", "A",   ---> All borders displayed
%  "north", "NORTH", "n", "N",   ---> North Border
%  "south", "SOUTH", "s", "S",   ---> South Border
%   "east",  "EAST", "e", "E",   --->  East Border
%   "west",  "WEST", "w", "W",   --->  West Border
%

%
%    Autor: Vinayak Dutt, Dutt.Vinayak@mayo.EDU  3 Jul 95 
%


  border = 0;
  arg = side;

  if ( ! isstr(arg) )
	error "plot_border: input not a string"
  endif;

% check first argument

  south = strcmp(arg,"south") || strcmp(arg,"SOUTH") ;
  south = south || strcmp(arg,"s") || strcmp(arg,"S") ;
  north = strcmp(arg,"north") || strcmp(arg,"NORTH") ;
  north = north || strcmp(arg,"n") || strcmp(arg,"N") ;
  east  = strcmp(arg,"east") || strcmp(arg,"EAST") ;
  east  =  east || strcmp(arg,"e") || strcmp(arg,"E") ;
  west  = strcmp(arg,"west") || strcmp(arg,"WEST") ;
  west  =  west || strcmp(arg,"w") || strcmp(arg,"W") ;
  all   = strcmp(arg,"all") || strcmp(arg,"ALL") ;
  all   =  all  || strcmp(arg,"a") || strcmp(arg,"A") ;
  blank = strcmp(arg,"blank") || strcmp(arg,"BLANK") ;
  blank = blank || strcmp(arg,"b") || strcmp(arg,"B") ;

  if ( south )
	border = 1;
  elseif ( north )
	border = 4;
  elseif ( east )
	border = 8;
  elseif ( west )
	border = 2;
  elseif ( all )
	border = 15;
  elseif ( blank )
	border = 0;
  endif;

%  check the remaining arguments

  va_start();
  while (--nargin)
	  arg = va_arg();
	  if ( ! isstr(arg) ) 
		error "plot_border: input not a string"
	  endif;

	  south = strcmp(arg,"south") || strcmp(arg,"SOUTH") ;
	  south = south || strcmp(arg,"s") || strcmp(arg,"S") ;
	  north = strcmp(arg,"north") || strcmp(arg,"NORTH") ;
	  north = north || strcmp(arg,"n") || strcmp(arg,"N") ;
	  east  = strcmp(arg,"east") || strcmp(arg,"EAST") ;
	  east  =  east || strcmp(arg,"e") || strcmp(arg,"E") ;
	  west  = strcmp(arg,"west") || strcmp(arg,"WEST") ;
	  west  =  west || strcmp(arg,"w") || strcmp(arg,"W") ;
	  all   = strcmp(arg,"all") || strcmp(arg,"ALL") ;
	  all   =  all  || strcmp(arg,"a") || strcmp(arg,"A") ;
	  blank = strcmp(arg,"blank") || strcmp(arg,"BLANK") ;
	  blank = blank || strcmp(arg,"b") || strcmp(arg,"B") ;

	  if ( south )
		border = border + 1;
	  elseif ( north )
		border = border + 4;
	  elseif ( east )
		border = border + 8;
	  elseif ( west )
		border = border + 2;
	  elseif ( all )
		border = 15;
	  elseif ( blank )
		border = 0;
	  endif;
%
  end;

  if ( border == 0 )
	set noborder;
  else
 	 command = sprintf ("set border %d", border);
  	eval (command);
  endif;

endfunction
