function [at,bt,ct,dt] = ss2ss(a,b,c,d,T)

% Usage: [at,bt,ct,dt] = ss2ss(A,B,C,D,T)
%
% Converts from one state-space form to an equivalent
% state-space form via a similarity transform.
% Given the system:
%   .
%   x = A x + B u
%   y = C x + D u
%
% and a mapping to a new set of states:
%
%   z = T x
%
% an equivalent system can be formed:
%   .        -1
%   z = T A T  z + T B u
%            -1
%   y =   C T  z +   D u
%
% Note: ss2ss() works for continuous and discrete systems.

% Written by Michael Fikes (mfikes@mnsinc.com) September 1995.

% Check args
if nargin != 5
   usage("ss2ss(A,B,C,D,T)");
end
[m,n,p] = abcddim(a,b,c,d);
[tr,tc]=size(T);
if (tr != tc)
   error("ss2ss: T must be square");
end
if (tr != n)
   error("ss2ss: T and A are incompatible");
end
if (det(T) == 0)
   error("ss2ss: T must be invertible");
end

invT=inv(T);
at=T*a*invT;
bt=T*b;
ct=c*invT;
dt=d;


