function [num,den] = ss2tf(a,b,c,d,iu)

% Usage: [num,den] = ss2tf(a,b,c,d,iu)
%
% Converts from state-space to transfer function form.
% A SIMO system is formed by considering only the iu'th
% input to the MIMO system represented by a, b, c, d.
% The transfer function form is
%
%                -1         num(s)
% G(s) = C (sI-A)  B + D =  ------
%                           den(s)
%
% The outputs num and den are the polynomial coefficients
% for num(s) and den(s).  The number of rows in num equals
% the number of system outputs.
%
% Note: ss2tf() also works for discrete systems.

% Written by Michael Fikes (mfikes@mnsinc.com) September 1995.

% check args
if (nargin != 5)
  usage("ss2tf(a,b,c,d,iu)");
end

[n,m,p] = abcddim(a,b,c,d);

if (iu < 1 || iu > m)
  error("ss2tf: iu not compatible with number of system inputs");
end

den = poly(a);
num = zeros(p,n+1);
for k = 1:p
   num(k,:) = poly(a - b(:,iu)*c(k,:)) - poly(a) + d(k,iu)*den;
end

