function playaudio (name, ext)
  
  # usage: 
  #   playaudio ("name" [, "ext"]) 
  #   playaudio (X)
  #
  # `playaudio ("name" [, "ext"])' plays the audio file "name.ext". The
  # default value for the "ext" argument, which has to be written
  # without the initial ".", is "lin".
  # Currently, the following audio formats are suppored:
  # *) linear encoding with extension "lin" or "raw", played using
  #    /dev/dsp 
  # *) mu-law encoding with extension "mu", "au" or "snd", played
  #    using /dev/audio 
  #
  # `playaudio (X)' plays the audio data contained in the vector X.

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Apr 11, 1994
  # Last modified by AW on Nov 7, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  # create name for temporary files
  pid = system ("echo -n $PPID", 1);
  file = ["/usr/tmp/tmp", pid];

  usage = ["usage:  playaudio (\"name\" [, \"ext\"])", ...
      "or playaudio (X)"];
  
  if ((nargin == 1) && is_vector (name) && !isstr (name)) 
    # play a vector
    [nr nc] = size (name);
    if (nc != 1)
      if (nr == 1)
	name = name';
	nr = nc;
      else
	error ("playaudio:  X must be a vector");
      endif
    endif
    X = name + 127;
    num = fopen (file, "w");
    c = fwrite (num, X, 'uchar');
    fclose (num);
    eval (sprintf ("system ('cat %s > /dev/dsp')", file));
    eval (sprintf ("system ('rm -f %s')", file));
  elseif ((nargin >= 1) && isstr(name))
    # play a file
    if (nargin == 1)
      name = [name, ".lin"];
    elseif (nargin == 2)
      name = [name, ".", ext];
    else
      error (usage);
    endif
    if (strcmp (ext, "lin") || strcmp (ext, "raw"))
      eval (sprintf ("system ('cat %s > /dev/dsp')", name));
    elseif (strcmp (ext, "mu") || strcmp (ext, "au") ...
	|| strcmp (ext, "snd"))
      eval (sprintf ("system ('cat %s > /dev/audio')", name));
    else
      error ("error:  playaudio does not support given extension");
    endif
  else
    error (usage);
  endif

endfunction

