function sound(y)
# sound(y):  sends the information in vector "y" out 
#		the sound interface on SPARC computer. 
#		The sampling frequency is fixed at 8.192 kHz.
#		The vector is autoscaled to provide maximum 
#		amplitude.

#	Author:  V.A.S.; vabreu@tsc.uvigo.es; 1-1995 

#
#  VOLUME CONTROL

smin = -32767;
smax = 32767;
slope = 2/(smax-smin);
y(:) = slope*y;


#  APLLICATION OF MU LAW

factor  = 32768;
bias    =   132;
aux     = 32635;
offset  =   335;

y = factor*y;
sig = sign(y) + (y==0);
y = min(abs(y),aux);
yy = log2(y+bias);
if yy<0
	e=floor(yy);
else
	e=ceil(yy);
end
f= (y+bias) .* 2.^(-e);
mu = 64*sig - 16*e - fix(32*f) + offset;

# SENDING TO THE AUDIO INTERFACE

fp = fopen('/dev/audio','w');
fwrite(fp,mu,'uchar');
fclose(fp);

endfunction