function [X]=aload(filename,nr,offset)
% function [X]=aload(filename,nr,offset) loads a flat ASCII file into X. 
% Also accepts the syntax [X]=aload(filename,[nr,offset]).
%
% nr     - number of rows    (0 = all (default))
% offset - first line to read, default 1.

% Eyal Doron, July 1995 (doron@mickey.mpi-hd.mpg.de)

if nargin<1
  help aload
  return
end
if (~exist(filename))
  error(['aload: file "', filename, '" not found.'])
end

X=[];
if nargin<2
  nr=0; offset=1;
elseif nargin==2
  if length(nr)==2
    offset=nr(2); nr=nr(1);
  else
    offset=1;
  end
end
offset=max([floor(offset),1]); nr=max([floor(nr),0]);

Cmd=["wc -lw ", filename, " | awk '", '{printf "WC=[%g,%g];",$1,$2}',"'"];
eval(shell_cmd(Cmd,1)); 
if ~all(WC) 
  error(sprintf('aload: "%s" contains zero rows/columns.',filename))
end
nc=WC(2)/WC(1);
if nc~=ceil(nc)
  error(sprintf('aload: "%s" does not have a constant number of columns.',filename))
end
nrfound=WC(1)-offset+1;
if nrfound<1
  error(sprintf("aload: offset > number of rows (%i)!",WC(1)))
end
if nr<1, nr=nrfound; end
if nr>nrfound
  error(sprintf("aload: tried to read too many rows, max is %i!", ...
      nrfound))
end

Tname=octave_tmp_file_name;
fid=fopen(Tname,"w");
fprintf(fid,"# name: localX\n# type: matrix\n");
fprintf(fid,"# rows: %g\n# columns: %g\n",nr,nc);
fclose(fid);

if nargin<2
  Cmd=sprintf("/bin/cat %s >> %s",filename,Tname);
elseif offset==1
  Cmd=sprintf("/usr/bin/head -n %i %s >> %s",nr,filename,Tname);
else  
  Cmd=sprintf("/usr/bin/tail -n +%i %s | /usr/bin/head -n %i >> %s", ...
      offset,filename,nr,Tname);
end

[out,err]=shell_cmd(Cmd);
if err != 0
  [out,err]=shell_cmd(["/bin/rm -f ", Tname]);
  error(['aload: couldn''t execute "',Cmd,'".'])
end

eval(["load -force -ascii ",Tname]);
X=localX;

[out,err]=shell_cmd(["/bin/rm -f ", Tname]);

endfunction