function p = path(p1,p2)
%
% path, this is a substitute for the Matlab 4.2 'path' command
%
%   path          returns the value of LOADPATH
%   path(p)       sets LOADPATH to 'p' and returns the value;
%   path(p1,p2)   sets LOADPATH to the concatenation of p1 and p2 and returns the value;
%                 thus:  path(path,'xxx')  adds 'xxx' to the LOADPATH
%                        path('xxx',path)  ....
%
% by cfm@sth.ruhr-uni-bochum.de 07.12.94
%
global LOADPATH
if(nargin==0) p = LOADPATH ; return; end;
if(nargin==1) LOADPATH = p1; p = LOADPATH; return; end;
if(nargin==2)
  LOADPATH = [ p1,':',p2 ];
  p = LOADPATH;
  return;
end;
