function x = arma_rnd (a, b, v, t, n)
  
  # usage: arma_rnd (a, b, v, t [, n])
  #
  # Returns a simulation of the ARMA model
  #   x(n) = a(1) * x(n-1) + ... + a(k) * x(n-k) +
  #              + e(n) + b(1) * e(n-1) + ... + b(l) * e(n-l),
  # where k is the length of vector a, l is the length of vector b and
  # e is gaussian white noise with variance v.  The function returns a
  # vector of length t.  
  #
  # The optional parameter n gives the number of dummy x(i) used for
  # initialization, i.e., a sequence of length t+n is generated and
  # x(n+1:t+n) is returned.  If n is omitted, n=100 is used. 
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Sep 7, 1993
  # Copyright Dept of Probability Theory and Statistics TU Wien  

  if nargin == 4
    n = 100;
  elseif nargin == 5
    if !is_scalar (t)
      error ("arma_rnd: n must be a scalar");
    endif
  else
    error ("usage: arma_rnd (a, b, v, t [, n])");
  endif

  if ( (min (size (a)) > 1) || (min (size (b)) > 1) )
    error ("arma: a and b must not be matrices");
  endif
  
  if !is_scalar (t)
    error ("arma_rnd: t must be a scalar");
  endif
  
  tmp = empty_list_elements_ok;
  empty_list_elements_ok = "true";
  
  ar = length (a);
  br = length (b);

  a = reshape (a, ar, 1);
  b = reshape (b, br, 1);
  
  a = [1; -a];         # apply our notational convention
  b = [1; b];
  
  n = min (n, ar + br);
  
  orig_dist = rand ("dist");
  rand ("normal");
  
  e = sqrt (v) * rand (t+n, 1);
  
  x = filter (b, a, e);
  x = x(n+1:t+n);
  
  rand (orig_dist);
  empty_list_elements_ok = tmp;
  
endfunction

  
  
  
  
  
    
    
    