function retval = autocorr (X, h)
  
  # usage: autocorr (X [, h])
  # 
  # returns the autocorrelations from lag 0 to h of vector X.
  # If h is omitted, all autocorrelations are computed.
  # If X is a matrix, the autocorrelations of every single column are
  # computed. 
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) Dec 28, 1993
  # Updated by FL on Sep 5, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin == 1)
    retval = autocov (X);
  elseif (nargin == 2)
    retval = autocov (X, h);
  else
    error ("usage: autocorr(X [, h])");    
  endif
  
  if (min (retval (1,:)) != 0)
    retval = retval ./ ( ones (rows (retval), 1) * retval(1, :) );
  endif
  
endfunction
    

  
