function retval = autocov (X, h)
  
  # usage: autocov (X [, h])
  # 
  # returns the autocovariances from lag 0 to h of vector X.
  # If h is omitted, all autocovariances are computed.
  # If X is a matrix, the autocovariances of every single column are
  # computed. 
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Dec 28, 1993
  # Updated by FL on Sep 5, 1994
  # Updated by FL on Oct 6, 1994
  # Copyright Department of Probability Theory and Statistics TU Wien
  
  [n c] = size (X);
  
  if (is_vector (X))
    n = length (X);
    c = 1;
    X = reshape (X, n, 1);
  endif
  
  X = center (X);
  
  if (nargin == 1)
    h = n - 1;
  endif
  
  retval = zeros (h + 1, c);
  
  oldpcv = prefer_column_vectors;
  prefer_column_vectors = "false";

  for i = 0 : h
    retval(i+1, :) = diag (X(i+1:n, :).' * conj (X(1:n-i, :))) / n;
  endfor
  
  prefer_column_vectors = oldpcv;
  
endfunction
