function X = autoreg_matrix (y, k)

  # usage:  X = autoreg_matrix (y, k)
  #
  # Given a time series (vector) y, returns a matrix X with ones in
  # the first column and the first k lagged values of y in the other
  # columns. 
  # I.e., for t > k, [1, y(t-1), ..., y(t-k)] is the t-th row of X.
  # X can be used as regressor matrix in autoregressions.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 11, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 2)
    error ("usage:  autoreg_matrix (y, k)");
  endif
  
  if !(is_vector (y))
    error ("autoreg_matrix:  y must be a vector");
  endif
  
  T = length (y);
  y = reshape (y, T, 1);
  X = ones (T, k+1);
  for j = 1 : k;
    X(:, j+1) = [zeros (j, 1); y(1:T-j)];
  endfor
  
endfunction

